---
title: XTTS-V2 API Usage Guide
slug: 6DCWoM_fbbp1XuSHH8vVc
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# XTTS-V2 API Usage Guide

## Introduction

This document will guide developers on how to use the aonet library to call the XTTS-V2 API, which is used for voice cloning and text-to-speech conversion.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Installation

Ensure that the aonet library is installed. If it is not installed yet, you can install it using npm:

```bash
npm install aonet
```

## Steps to Use

### 1. Import the aonet library

```js
const AI = require("aonet");
```

### 2. Configure Options

Create an options object that includes your APPID:

```js
const options = {
    appid: "your APPID"
};
```

Make sure to replace "your APPID" with your actual Aonet APPID.

### 3. Initialize AI Instance

Initialize the AI instance using the configuration options:

```js
const aonet = new AI(options);
```

### 4. Call the XTTS-V2 API

Use the `prediction` method to call the XTTS-V2 API:

```js
async function generateClonedVoice() {
    try {
        let response = await aonet.prediction("/predictions/ai/xtts-v2",
        {
            input: {
                "text": "Hi there, I'm your new voice clone. Try your best to upload quality audio",
                "speaker": "https://aonet.ai/pbxt/Jt79w0xsT64R1JsiJ0LQRL8UcWspg5J4RFrU6YwEKpOT1ukS/male.wav",
                "language": "en",
                "cleanup_voice": false
            }
        });
        console.log("XTTS-V2 result:", response);
    } catch (error) {
        console.error("Error generating cloned voice:", error);
    }
}

generateClonedVoice();
```

### Parameter Description

- `text`: String, the text content to be converted into speech.
- `speaker`: String, the URL of the audio file used as the voice sample for cloning.
- `language`: String, specifies the language of the text, with "en" indicating English.
- `cleanup_voice`: Boolean, whether to perform cleanup processing on the generated voice.

### Notes

- Ensure that the provided audio URL is publicly accessible and of good quality to achieve the best cloning effect.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations, especially when handling voice samples of others.

### Example Response

The API response will contain the URL of the generated cloned voice or other relevant information. Parse and use the response data according to the actual API documentation.

## Advanced Usage

- Implement batch text-to-speech conversion by processing multiple text segments in a loop or concurrent requests.
- Add a user interface that allows users to upload their own voice samples and input custom text.
- Implement voice post-processing features, such as adjusting volume, adding background music, or applying audio effects.
- Integrate a voice storage solution to save and manage the generated voice files.
- Consider implementing a voice recognition feature to convert the generated voice back to text for verification or other purposes.

